@extends('layouts.admin')

@section('title', 'Servers')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Servers</h1>
            <a href="{{ route('admin.servers.create') }}" class="btn btn-primary">
                <i class="fas fa-plus"></i> Add Server
            </a>
        </div>
        <p>Manage your game servers</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Server List</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Address</th>
                            <th>App ID</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($servers as $server)
                        <tr>
                            <td>{{ $server->name }}</td>
                            <td>{{ $server->ip }}:{{ $server->port }}</td>
                            <td>{{ $server->app_id }}</td>
                            <td>
                                @if($server->is_active)
                                <span class="server-status-badge online">
                                    <i class="fas fa-circle"></i> Active
                                </span>
                                @else
                                <span class="server-status-badge offline">
                                    <i class="fas fa-circle"></i> Inactive
                                </span>
                                @endif
                            </td>
                            <td class="user-actions">
                                <a href="{{ route('admin.servers.show', $server->id) }}" class="btn-icon btn-primary" title="View Server">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="{{ route('admin.servers.edit', $server->id) }}" class="btn-icon btn-info" title="Edit Server">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.servers.destroy', $server->id) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this server?');" style="display: inline;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-icon btn-danger" title="Delete Server">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No servers found.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection